#version 430



vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

layout(triangles) in;
layout(triangle_strip, max_vertices = 15) out;
//layout(line_strip, max_vertices = 15) out;

// layout(binding=0, offset=0) uniform atomic_uint ac;

in vec3 normal[3];
in vec2 uv[3];
in vec3 tangent[3];
in float bright[3];

out vec4 posG;
out vec3 normalG;
out vec3 normalWSG;
out vec2 uvG;
out vec3 tangentG;
out vec3 colorG;
out vec4 posW;
out float brightG;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelMatrix;

uniform float g_time;

uniform float windowWidth;
uniform float windowHeight;

uniform float furLength = 1.0;

// uniform float makkara;

layout(binding=0) uniform sampler2D tex;

void main(void) {

        vec3 controlBase = vec3(0.0);
		
//		uint counter = atomicCounterIncrement(ac);

        float times = g_time*0.1;
       vec3 faceNormal = vec3(0.0);
        vec4 facePos = vec4(0.0);
        for (int i = 0; i < gl_in.length(); ++i) {
                gl_Position = gl_in[i].gl_Position; // -vec4(1.5, 0.0, 0.0, 0.0);
                gl_Position.xyz -= normal[i]*0.0;
                // gl_Position.xyz -= normal[i]*1.5;
                posW = modelMatrix*gl_Position;
                gl_Position = projectionMatrix * modelViewMatrix * gl_Position;
                normalG = normal[i];
                vec4 jk = (modelMatrix * vec4(normalG, 0.0));
                normalWSG = jk.xyz;
                normalG = (modelMatrix * vec4(normalG, 0.0)).xyz;

brightG = bright[i];

                posG = gl_Position;
             //   controlG = controlBase;
             //   controlG.r = 0.1;
                faceNormal += normal[i];
                uvG = uv[i];
                tangentG = tangent[i];
                EmitVertex();
        }
        facePos /= 3.0;

        EndPrimitive();


}
